// server.js
const express = require("express");
const path = require("path");
require("dotenv").config();

const app = express();
const PORT = process.env.PORT || 3000;

// Set up EJS as the view engine
app.set("view engine", "ejs");
app.set("views", path.join(__dirname, "views"));

// Serve static files from the public directory
app.use(express.static(path.join(__dirname, "public")));

// Create a config.js endpoint to expose environment variables to the client
app.get("/config.js", (req, res) => {
  res.setHeader("Content-Type", "application/javascript");
  res.send(`
    window.APP_CONFIG = {
      // Firebase configuration
      FIREBASE_API_KEY: "${
        process.env.FIREBASE_API_KEY ||
        "AIzaSyCu-x1Vi2nPCwkf9YWZmVezuNHeSXW5lBk"
      }",
      FIREBASE_AUTH_DOMAIN: "${
        process.env.FIREBASE_AUTH_DOMAIN ||
        "notification-test-f335f.firebaseapp.com"
      }",
      FIREBASE_PROJECT_ID: "${
        process.env.FIREBASE_PROJECT_ID || "notification-test-f335f"
      }",
      FIREBASE_STORAGE_BUCKET: "${
        process.env.FIREBASE_STORAGE_BUCKET ||
        "notification-test-f335f.firebasestorage.app"
      }",
      FIREBASE_MESSAGING_SENDER_ID: "${
        process.env.FIREBASE_MESSAGING_SENDER_ID || "900396194062"
      }",
      FIREBASE_APP_ID: "${
        process.env.FIREBASE_APP_ID ||
        "1:900396194062:web:9e6dc43fe2b79e617c9f5f"
      }",
      FIREBASE_MEASUREMENT_ID: "${
        process.env.FIREBASE_MEASUREMENT_ID || "G-186DCDXVLG"
      }",
      FIREBASE_DATABASE_URL: "${
        process.env.FIREBASE_DATABASE_URL ||
        "https://notification-test-f335f-default-rtdb.firebaseio.com"
      }",
      
      // Chat configuration
      MAX_MESSAGE_LENGTH: ${process.env.MAX_MESSAGE_LENGTH || 600},
      MAX_USERNAME_LENGTH: ${process.env.MAX_USERNAME_LENGTH || 20},
      DEFAULT_USERNAME: "${process.env.DEFAULT_USERNAME || "Anonymous"}",
      GEMINI_API_KEY: "${
        process.env.GEMINI_API_KEY || "AIzaSyD86YbgJcODJ0j1z0TtvmIusvWoRatEXsE"
      }",
      MAX_ROOMS_PER_USER: ${process.env.MAX_ROOMS_PER_USER || 5},
      DEFAULT_MAX_ROOM_MEMBERS: ${process.env.DEFAULT_MAX_ROOM_MEMBERS || 20},
      ENABLE_ROOM_NOTIFICATIONS: ${
        process.env.ENABLE_ROOM_NOTIFICATIONS || true
      },
    };
  `);
});

// Main route
app.get("/", (req, res) => {
  res.render("index", {
    title: process.env.APP_TITLE || "3D Chat App",
    description:
      process.env.APP_DESCRIPTION || "A 3D interactive chat application",
    chatTitle: process.env.CHAT_TITLE || "3D Chat",
    messagePlaceholder: process.env.MESSAGE_PLACEHOLDER || "Type a message...",
    usernamePlaceholder: process.env.USERNAME_PLACEHOLDER || "Your name",
    sendButtonText: process.env.SEND_BUTTON_TEXT || "Send",
    maxMessageLength: process.env.MAX_MESSAGE_LENGTH || 600,
    maxUsernameLength: process.env.MAX_USERNAME_LENGTH || 20,
  });
});

// Start the server
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});
